## The *cleveref-usedon* package
Patches the cleveref package and adds forward-referencing functionality

## Description
Imagine you are reading a long mathematical text such as a text book 
or a thesis. There are plenty of supplementary lemmas, propositions, 
theorems and/or exercises throughout the whole text. 

You ask yourself *"Gosh, while Lemma 1.12 is certainly an interesting 
result **where** is this result used later on in this long text? I 
really would find that helpful to decide **why** I should read the 
proof."*

You can, of course, use the PDF search function of your viewer to 
look up the string *"Lemma 1.12"* but wouldn't it be more helpful 
if Lemma 1.12 already indicates all or at least its most 
useful/crucial applications via an info message?

This is what the package **cleveref-usedon** tries to address.
The info message *"Used on p. 40, 43-45 and 101."* would then be
printed to the header of Lemma 1.12.

Check the [package documentation](./cleveref-usedon.pdf) for more info on the usage or look at an [example](https://github.com/SvenPistre/cleveref-usedon/tree/main/examples) directly.

## Installation
Place the file ``cleveref-usedon.sty`` at a location which your LaTeX distribution understands. For instance, on OS X you can place it in ``~/Library/texmf/tex/latex``.
If you don't know where that would be on your OS, you can also simply drop this file in the same directory as the ``.tex`` file where you want to use the package.

If you wish you can also 'compile' the package style file ``cleveref-usedon.sty`` and the documentation ``cleveref-usedon.pdf`` 'from source' as follows:
- To generate the package style file, run the installation file ``cleveref-usedon.ins`` through pdflatex. 
- To generate the documentation, run the DocStrip file ``cleveref-usedon.dtx`` through pdflatex. 

---
Copyright (C) 2023  Sven Pistre

E-mail:   [cleveref-usedon@sven-pistre.com](mailto:cleveref-usedon@sven-pistre.com?subject=[cleveref-usedon])
```
Files:
cleveref.ins  Batch file, run through LaTeX
cleveref.dtx  Docstrip archive, run through LaTeX
cleveref.sty  LaTeX package, generated by cleveref.ins from cleveref.dtx
cleveref.pdf  Package documentation, generated from cleveref.dtx
README        This file

This file may be distributed and/or modified under the
conditions of the LaTeX Project Public License, either
version 1.3 of this license or (at your option) any later
version. The latest version of this license is in:

      http://www.latex-project.org/lppl.txt

and version 1.3 or later is part of all distributions of
LaTeX version 2005/12/01 or later.
```
---