/*
 * This utility is used for project development.
 */
#include <stdlib.h>
#include "dos.h"

#define HEADERFILE_C "version.h"
#define HEADERFILE_ASM "version.inc"
#define VERSION    "3.2"

main( int argc, char **argv ) {

    int fptr;
    struct RealTimeClock rtc;
    char buffer[100];
    char dst = 0;

    if( argc != 2 )
        goto usage;

    if( argv[1][0] == '-' )
        dst = argv[1][1];
    else {
        printf( "bad option '%c' ", argv[1][1] );
        goto usage;
    }

    if( GetRTC( &rtc ) == 0 ) {
        printf( "could not read real time clock\n" );
        exit( 99 );
    }

    if( dst == 'h' ) {
        fptr = Create( HEADERFILE_C, 0 );
        if( fptr == -1 ) {
            printf( "could not open header file %s\n", HEADERFILE_C );
            exit( 99 );
        }

        sprintf( buffer, "#define VERSIONSTRING \"%s\"\x0d\x0a", VERSION );
        _Write( fptr, buffer, strlen( buffer ) );
        sprintf( buffer, "#define RELEASESTRING \"%d.%02d%02d\"\x0d\x0a",
            rtc.Year - 1900, rtc.Month, rtc.Day );
        _Write( fptr, buffer, strlen( buffer ) );
        Close( fptr );
    } else if( dst == 'i' ) {
        fptr = Create( HEADERFILE_ASM, 0 );
        if( fptr == -1 ) {
            printf( "could not open header file %s\n", HEADERFILE_ASM );
            exit( 99 );
        }

        sprintf( buffer, "VERSIONSTRING EQU '%s'\x0d\x0a", VERSION );
        _Write( fptr, buffer, strlen( buffer ) );
        sprintf( buffer, "RELEASESTRING EQU '%d.%02d%02d'\x0d\x0a",
            rtc.Year - 1900, rtc.Month, rtc.Day );
        _Write( fptr, buffer, strlen( buffer ) );
        Close( fptr );
    } else
        goto usage;

    exit( 0 );

usage:
    printf( "usage: version {-i|-h}\n" );
    exit( 99 );
}
