/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class Semaphore {
    private final Sync sync = new Sync();

    public Semaphore() {
    }

    public Semaphore(int downs) {
        if (downs < 0) {
            throw new IllegalArgumentException("A non-negative amount of 'downs' expected, found " + downs);
        }
        for (int i2 = 0; i2 < downs; ++i2) {
            this.down();
        }
    }

    public void up() {
        this.tryUp();
    }

    public boolean tryUp() {
        return this.sync.releaseShared(1);
    }

    public void down() {
        this.sync.down();
    }

    public void waitFor() {
        try {
            this.waitForUnsafe();
        }
        catch (InterruptedException e2) {
            throw new ProcessCanceledException(e2);
        }
    }

    public void waitForUnsafe() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean waitFor(long msTimeout) {
        try {
            return this.waitForUnsafe(msTimeout);
        }
        catch (InterruptedException e2) {
            throw new ProcessCanceledException(e2);
        }
    }

    public boolean waitForUnsafe(long msTimeout) throws InterruptedException {
        if (this.sync.tryAcquireShared(1) >= 0) {
            return true;
        }
        return this.sync.tryAcquireSharedNanos(1, TimeUnit.MILLISECONDS.toNanos(msTimeout));
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            int next;
            int c2;
            do {
                if ((c2 = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c2, next = c2 - 1));
            return next == 0;
        }

        private void down() {
            int next;
            int current;
            while (!this.compareAndSetState(current = this.getState(), next = current + 1)) {
            }
        }
    }
}

