/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientCancellationHandler;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

@ThreadSafe
public class WorkerDaemonFactory
implements WorkerFactory {
    private final WorkerDaemonClientsManager clientsManager;
    private final BuildOperationRunner buildOperationRunner;
    private final WorkerDaemonClientCancellationHandler workerDaemonClientCancellationHandler;

    public WorkerDaemonFactory(WorkerDaemonClientsManager clientsManager, BuildOperationRunner buildOperationRunner, WorkerDaemonClientCancellationHandler workerDaemonClientCancellationHandler) {
        this.clientsManager = clientsManager;
        this.buildOperationRunner = buildOperationRunner;
        this.workerDaemonClientCancellationHandler = workerDaemonClientCancellationHandler;
    }

    @Override
    public BuildOperationAwareWorker getWorker(final WorkerRequirement workerRequirement) {
        return new AbstractWorker(this.buildOperationRunner){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DefaultWorkResult execute(IsolatedParametersActionExecutionSpec<?> spec, BuildOperationRef parentBuildOperation) {
                WorkerDaemonFactory.this.workerDaemonClientCancellationHandler.start();
                WorkerDaemonClient client = (WorkerDaemonClient)CurrentBuildOperationRef.instance().with(parentBuildOperation, this::reserveClient);
                try {
                    DefaultWorkResult defaultWorkResult = this.executeWrappedInBuildOperation(spec, parentBuildOperation, client::execute);
                    return defaultWorkResult;
                }
                finally {
                    WorkerDaemonFactory.this.clientsManager.release(client);
                }
            }

            private WorkerDaemonClient reserveClient() {
                DaemonForkOptions forkOptions = ((ForkedWorkerRequirement)workerRequirement).getForkOptions();
                WorkerDaemonClient client = WorkerDaemonFactory.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = WorkerDaemonFactory.this.clientsManager.reserveNewClient(forkOptions);
                }
                return client;
            }
        };
    }
}

