/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import com.google.common.collect.ImmutableList;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemLookup;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.exceptions.NonGradleCause;
import org.gradle.internal.exceptions.NonGradleCauseExceptionsHolder;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.BufferingStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.problems.internal.rendering.ProblemRenderer;
import org.gradle.util.internal.GUtil;

@NonNullApi
public class BuildExceptionReporter
implements Action<Throwable> {
    private static final String NO_ERROR_MESSAGE_INDICATOR = "(no error message)";
    public static final String RESOLUTION_LINE_PREFIX = "> ";
    public static final String LINE_PREFIX_LENGTH_SPACES = StringUtils.repeat((String)" ", (int)"> ".length());
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData, GradleEnterprisePluginManager gradleEnterprisePluginManager) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
    }

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this(textOutputFactory, loggingConfiguration, clientMetaData, null);
    }

    public void buildFinished(BuildResult result) {
        this.buildFinished(result, t -> Collections.emptyList());
    }

    public void buildFinished(BuildResult result, ProblemLookup problemLookup) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure, problemLookup);
    }

    public void execute(@Nonnull Throwable failure) {
        this.execute(failure, t -> Collections.emptyList());
    }

    public void execute(@Nonnull Throwable failure, ProblemLookup problemLookup) {
        if (failure instanceof MultipleBuildFailures) {
            this.renderMultipleBuildExceptions((MultipleBuildFailures)((Object)failure), problemLookup);
        } else {
            this.renderSingleBuildException(failure, problemLookup);
        }
    }

    private void renderMultipleBuildExceptions(MultipleBuildFailures failure, ProblemLookup problemLookup) {
        String message = failure.getMessage();
        List flattenedFailures = failure.getCauses();
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: %s", new Object[]{message});
        output.println();
        for (int i = 0; i < flattenedFailures.size(); ++i) {
            Throwable cause = (Throwable)flattenedFailures.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause, problemLookup);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", new Object[]{i + 1});
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text((Object)"-----------");
            this.writeFailureDetails(output, details);
            output.println((Object)"==============================================================================");
        }
    }

    private void renderSingleBuildException(Throwable failure, ProblemLookup problemLookup) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure, problemLookup);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text((Object)"FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        this.writeFailureDetails(output, details);
    }

    private static boolean hasCauseAncestry(Throwable failure, Class<?> type) {
        for (Throwable cause = failure.getCause(); cause != null; cause = cause.getCause()) {
            if (!BuildExceptionReporter.hasCause(cause, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCause(Throwable cause, Class<?> type) {
        if (cause instanceof NonGradleCauseExceptionsHolder) {
            return ((NonGradleCauseExceptionsHolder)cause).hasCause(type);
        }
        return false;
    }

    private ExceptionStyle getShowStackTraceOption() {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            return ExceptionStyle.FULL;
        }
        return ExceptionStyle.NONE;
    }

    private FailureDetails constructFailureDetails(String granularity, Throwable failure, ProblemLookup problemLookup) {
        FailureDetails details = new FailureDetails(failure, this.getShowStackTraceOption());
        details.summary.format("%s failed with an exception.", new Object[]{granularity});
        this.fillInFailureResolution(details, problemLookup);
        if (failure instanceof ContextAwareException) {
            ((ContextAwareException)((Object)failure)).accept(new ExceptionFormattingVisitor(details, problemLookup));
        } else {
            details.appendDetails();
        }
        details.renderStackTrace();
        return details;
    }

    private void fillInFailureResolution(FailureDetails details, ProblemLookup problemLookup) {
        LogLevel logLevel;
        boolean isLessThanInfo;
        boolean shouldDisplayGenericResolutions;
        ContextImpl context = new ContextImpl(details.resolution);
        if (details.failure instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure)).appendResolutions(context);
        }
        BuildExceptionReporter.getResolutions(details.failure, problemLookup).stream().distinct().forEach(resolution -> context.appendResolution(output -> output.text((Object)String.join((CharSequence)("\n " + LINE_PREFIX_LENGTH_SPACES), resolution.split("\n")))));
        boolean bl = shouldDisplayGenericResolutions = !BuildExceptionReporter.hasCauseAncestry(details.failure, NonGradleCause.class) && !BuildExceptionReporter.hasProblemReportsWithSolutions(details.failure, problemLookup);
        if (details.exceptionStyle == ExceptionStyle.NONE && shouldDisplayGenericResolutions) {
            context.appendResolution(output -> BuildExceptionReporter.runWithOption(output, "stacktrace", " option to get the stack trace."));
        }
        boolean bl2 = isLessThanInfo = (logLevel = this.loggingConfiguration.getLogLevel()).ordinal() > LogLevel.INFO.ordinal();
        if (logLevel != LogLevel.DEBUG && shouldDisplayGenericResolutions) {
            context.appendResolution(output -> {
                output.text((Object)"Run with ");
                if (isLessThanInfo) {
                    output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"info"});
                    output.text((Object)" or ");
                }
                output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"debug"});
                output.text((Object)" option to get more log output.");
            });
        }
        if (!context.missingBuild && !this.isGradleEnterprisePluginApplied()) {
            this.addBuildScanMessage(context);
        }
        if (shouldDisplayGenericResolutions) {
            context.appendResolution(this::writeGeneralTips);
        }
    }

    private static boolean hasProblemReportsWithSolutions(Throwable throwable, ProblemLookup problemLookup) {
        Optional solution = problemLookup.findAll(throwable).stream().flatMap(p -> p.getSolutions().stream()).findFirst();
        if (solution.isPresent()) {
            return true;
        }
        return BuildExceptionReporter.hasProblemReportsWithSolutions(BuildExceptionReporter.getCauses(throwable), problemLookup);
    }

    private static boolean hasProblemReportsWithSolutions(List<? extends Throwable> throwables, ProblemLookup problemLookup) {
        return throwables.stream().anyMatch(t -> BuildExceptionReporter.hasProblemReportsWithSolutions(t, problemLookup));
    }

    private static void runWithOption(StyledTextOutput output, String optionName, String text) {
        output.text((Object)"Run with ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{optionName});
        output.text((Object)text);
    }

    private static List<String> getResolutions(Throwable throwable, ProblemLookup problemLookup) {
        ImmutableList.Builder resolutions = ImmutableList.builder();
        if (throwable instanceof ResolutionProvider) {
            resolutions.addAll((Iterable)((ResolutionProvider)throwable).getResolutions());
        }
        Collection all = problemLookup.findAll(throwable);
        for (Problem problem : all) {
            resolutions.addAll((Iterable)problem.getSolutions());
        }
        for (Throwable throwable2 : BuildExceptionReporter.getCauses(throwable)) {
            resolutions.addAll(BuildExceptionReporter.getResolutions(throwable2, problemLookup));
        }
        return resolutions.build();
    }

    private static List<? extends Throwable> getCauses(Throwable cause) {
        if (cause instanceof MultiCauseException) {
            return ((MultiCauseException)cause).getCauses();
        }
        Throwable nextCause = cause.getCause();
        return nextCause == null ? ImmutableList.of() : ImmutableList.of((Object)nextCause);
    }

    private void addBuildScanMessage(ContextImpl context) {
        context.appendResolution(output -> BuildExceptionReporter.runWithOption(output, "scan", " to get full insights."));
    }

    private boolean isGradleEnterprisePluginApplied() {
        return this.gradleEnterprisePluginManager != null && this.gradleEnterprisePluginManager.isPresent();
    }

    private void writeGeneralTips(StyledTextOutput resolution) {
        resolution.text((Object)"Get more help at ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).text((Object)"https://help.gradle.org");
        resolution.text((Object)".");
    }

    private static String getMessage(Throwable throwable, ProblemLookup problemLookup) {
        try {
            String message;
            String msg = throwable instanceof CompilationFailedIndicator ? ((CompilationFailedIndicator)throwable).getShortMessage() : throwable.getMessage();
            StringBuilder builder = new StringBuilder(msg == null ? "" : msg);
            Collection problems = problemLookup.findAll(throwable);
            if (!problems.isEmpty()) {
                String diagnosticCounts;
                builder.append(System.lineSeparator());
                StringWriter problemWriter = new StringWriter();
                new ProblemRenderer((Writer)problemWriter).render(new ArrayList(problems));
                builder.append(problemWriter);
                if (throwable instanceof CompilationFailedIndicator && (diagnosticCounts = ((CompilationFailedIndicator)throwable).getDiagnosticCounts()) != null) {
                    builder.append(System.lineSeparator());
                    builder.append(diagnosticCounts);
                }
            }
            if (GUtil.isTrue((Object)(message = builder.toString()))) {
                return message;
            }
            return String.format("%s %s", throwable.getClass().getName(), NO_ERROR_MESSAGE_INDICATOR);
        }
        catch (Throwable t) {
            return String.format("Unable to get message for failure of type %s due to %s", throwable.getClass().getSimpleName(), t.getMessage());
        }
    }

    private void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        BuildExceptionReporter.writeSection(details.location, output, "* Where:");
        BuildExceptionReporter.writeSection(details.details, output, "* What went wrong:");
        BuildExceptionReporter.writeSection(details.resolution, output, "* Try:");
        BuildExceptionReporter.writeSection(details.stackTrace, output, "* Exception is:");
    }

    private static void writeSection(BufferingStyledTextOutput textOutput, StyledTextOutput output, String sectionTitle) {
        if (textOutput.getHasContent()) {
            output.println();
            output.println((Object)sectionTitle);
            textOutput.writeTo(output);
            output.println();
        }
    }

    static void renderStyledError(Throwable failure, StyledTextOutput details, ProblemLookup problemLookup) {
        if (failure instanceof StyledException) {
            ((StyledException)((Object)failure)).render(details);
        } else {
            details.text((Object)BuildExceptionReporter.getMessage(failure, problemLookup));
        }
    }

    @NonNullApi
    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput stackTrace = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        final ExceptionStyle exceptionStyle;

        public FailureDetails(Throwable failure, ExceptionStyle exceptionStyle) {
            this.failure = failure;
            this.exceptionStyle = exceptionStyle;
        }

        void appendDetails() {
            BuildExceptionReporter.renderStyledError(this.failure, (StyledTextOutput)this.details, t -> Collections.emptyList());
        }

        void renderStackTrace() {
            if (this.exceptionStyle == ExceptionStyle.FULL) {
                try {
                    this.stackTrace.exception(this.failure);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @NonNullApi
    private static enum ExceptionStyle {
        NONE,
        FULL;

    }

    private static class ExceptionFormattingVisitor
    extends ExceptionContextVisitor {
        private final FailureDetails failureDetails;
        private final ProblemLookup problemLookup;
        private final Set<Throwable> printedNodes = new HashSet<Throwable>();
        private int depth;
        private int suppressedDuplicateBranchCount;

        private ExceptionFormattingVisitor(FailureDetails failureDetails, ProblemLookup problemLookup) {
            this.failureDetails = failureDetails;
            this.problemLookup = problemLookup;
        }

        @Override
        protected void visitCause(Throwable cause) {
            this.failureDetails.failure = cause;
            this.failureDetails.appendDetails();
        }

        @Override
        protected void visitLocation(String location) {
            this.failureDetails.location.text((Object)location);
        }

        @Override
        public void node(Throwable node) {
            if (this.shouldBePrinted(node)) {
                this.printedNodes.add(node);
                if (null == node.getCause() || this.isUsefulMessage(BuildExceptionReporter.getMessage(node, this.problemLookup))) {
                    LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
                    BuildExceptionReporter.renderStyledError(node, (StyledTextOutput)output, this.problemLookup);
                }
            } else if (node.getCause() == null) {
                ++this.suppressedDuplicateBranchCount;
            }
        }

        private boolean shouldBePrinted(Throwable node) {
            if (this.printedNodes.isEmpty()) {
                return true;
            }
            ArrayDeque<Throwable> next = new ArrayDeque<Throwable>();
            next.add(node);
            while (!next.isEmpty()) {
                Throwable curr = (Throwable)next.poll();
                if (this.printedNodes.contains(curr)) {
                    return false;
                }
                if (curr.getCause() != null) {
                    next.add(curr.getCause());
                }
                if (!(curr instanceof ContextAwareException)) continue;
                next.addAll(((ContextAwareException)((Object)curr)).getReportableCauses());
            }
            return true;
        }

        private boolean isUsefulMessage(String message) {
            return StringUtils.isNotBlank((String)message) && !message.endsWith(BuildExceptionReporter.NO_ERROR_MESSAGE_INDICATOR);
        }

        @Override
        public void startChildren() {
            ++this.depth;
        }

        @Override
        public void endChildren() {
            --this.depth;
        }

        private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput(FailureDetails details) {
            details.details.format("%n", new Object[0]);
            StringBuilder prefix = new StringBuilder(StringUtils.repeat((String)"   ", (int)(this.depth - 1)));
            details.details.text((Object)prefix);
            prefix.append("  ");
            details.details.style(StyledTextOutput.Style.Info).text((Object)BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            return new LinePrefixingStyledTextOutput((StyledTextOutput)details.details, (CharSequence)prefix, false);
        }

        @Override
        protected void endVisiting() {
            if (this.suppressedDuplicateBranchCount > 0) {
                boolean plural;
                LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
                boolean bl = plural = this.suppressedDuplicateBranchCount > 1;
                if (plural) {
                    output.append((CharSequence)String.format("There are %d more failures with identical causes.", this.suppressedDuplicateBranchCount));
                } else {
                    output.append((CharSequence)"There is 1 more failure with an identical cause.");
                }
            }
        }
    }

    @NonNullApi
    private class ContextImpl
    implements FailureResolutionAware.Context {
        private final BufferingStyledTextOutput resolution;
        private final DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        private boolean missingBuild;

        public ContextImpl(BufferingStyledTextOutput resolution) {
            this.resolution = resolution;
        }

        @Override
        public BuildClientMetaData getClientMetaData() {
            return BuildExceptionReporter.this.clientMetaData;
        }

        @Override
        public void doNotSuggestResolutionsThatRequireBuildDefinition() {
            this.missingBuild = true;
        }

        @Override
        public void appendResolution(Consumer<StyledTextOutput> resolutionProducer) {
            if (this.resolution.getHasContent()) {
                this.resolution.println();
            }
            this.resolution.style(StyledTextOutput.Style.Info).text((Object)BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            resolutionProducer.accept((StyledTextOutput)this.resolution);
        }

        @Override
        public void appendDocumentationResolution(String prefix, String userGuideId, String userGuideSection) {
            this.appendResolution(output -> output.text((Object)this.documentationRegistry.getDocumentationRecommendationFor(prefix, userGuideId, userGuideSection)));
        }
    }
}

