/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.LenientConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionExecutor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultGraphBuilder;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValue;

public class ShortCircuitingResolutionExecutor {
    private final ResolutionExecutor delegate;
    private final AttributeDesugaring attributeDesugaring;

    public ShortCircuitingResolutionExecutor(ResolutionExecutor delegate, AttributeDesugaring attributeDesugaring) {
        this.delegate = delegate;
        this.attributeDesugaring = attributeDesugaring;
    }

    public ResolverResults resolveBuildDependencies(ResolveContext resolveContext, CalculatedValue<ResolverResults> futureCompleteResults) {
        RootComponentMetadataBuilder.RootComponentState rootComponent = resolveContext.toRootComponent();
        LocalVariantGraphResolveState rootVariant = rootComponent.getRootVariant();
        if (ShortCircuitingResolutionExecutor.hasDependencies(rootVariant)) {
            return this.delegate.resolveBuildDependencies(resolveContext, futureCompleteResults);
        }
        VisitedGraphResults graphResults = this.emptyGraphResults(rootComponent.getRootComponent(), rootVariant);
        return DefaultResolverResults.buildDependenciesResolved(graphResults, EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved(EmptyResults.INSTANCE));
    }

    public ResolverResults resolveGraph(ResolveContext resolveContext, List<ResolutionAwareRepository> repositories) throws ResolveException {
        RootComponentMetadataBuilder.RootComponentState rootComponent = resolveContext.toRootComponent();
        LocalVariantGraphResolveState rootVariant = rootComponent.getRootVariant();
        if (ShortCircuitingResolutionExecutor.hasDependencies(rootVariant)) {
            return this.delegate.resolveGraph(resolveContext, repositories);
        }
        if (resolveContext.getResolutionStrategy().isDependencyLockingEnabled()) {
            DependencyLockingProvider dependencyLockingProvider = resolveContext.getResolutionStrategy().getDependencyLockingProvider();
            DependencyLockingState lockingState = dependencyLockingProvider.loadLockState(resolveContext.getDependencyLockingId(), resolveContext.getResolutionHost().displayName());
            if (lockingState.mustValidateLockState() && !lockingState.getLockedDependencies().isEmpty()) {
                return this.delegate.resolveGraph(resolveContext, repositories);
            }
            dependencyLockingProvider.persistResolvedDependencies(resolveContext.getDependencyLockingId(), resolveContext.getResolutionHost().displayName(), Collections.emptySet(), Collections.emptySet());
        }
        VisitedGraphResults graphResults = this.emptyGraphResults(rootComponent.getRootComponent(), rootVariant);
        DefaultResolvedConfiguration resolvedConfiguration = new DefaultResolvedConfiguration(graphResults, resolveContext.getResolutionHost(), EmptyResults.INSTANCE, new EmptyLenientConfiguration());
        return DefaultResolverResults.graphResolved(graphResults, EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(EmptyResults.INSTANCE, resolvedConfiguration));
    }

    private static boolean hasDependencies(LocalVariantGraphResolveState rootVariant) {
        if (!rootVariant.getFiles().isEmpty()) {
            return true;
        }
        for (DependencyMetadata dependencyMetadata : rootVariant.getDependencies()) {
            if (dependencyMetadata.isConstraint()) continue;
            return true;
        }
        return false;
    }

    private VisitedGraphResults emptyGraphResults(LocalComponentGraphResolveState rootComponent, VariantGraphResolveState rootVariant) {
        MinimalResolutionResult emptyResult = ResolutionResultGraphBuilder.empty(rootComponent.getModuleVersionId(), rootComponent.getId(), rootVariant.getAttributes(), ShortCircuitingResolutionExecutor.getCapabilities(rootComponent, rootVariant), rootVariant.getName(), this.attributeDesugaring);
        return new DefaultVisitedGraphResults(emptyResult, Collections.emptySet(), null);
    }

    private static ImmutableCapabilities getCapabilities(LocalComponentGraphResolveState rootComponent, VariantGraphResolveState rootVariant) {
        ImmutableCapabilities capabilities = rootVariant.getMetadata().getCapabilities();
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)rootComponent.getDefaultCapability());
        }
        return capabilities;
    }

    public static class EmptyResults
    implements VisitedArtifactSet,
    SelectedArtifactSet,
    ResolverResults.LegacyResolverResults.LegacyVisitedArtifactSet,
    SelectedArtifactResults {
        public static final EmptyResults INSTANCE = new EmptyResults();

        @Override
        public SelectedArtifactSet select(ArtifactSelectionSpec spec) {
            return this;
        }

        @Override
        public SelectedArtifactResults selectLegacy(ArtifactSelectionSpec spec, boolean lenient) {
            return this;
        }

        @Override
        public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec) {
            return this;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return ResolvedArtifactSet.EMPTY;
        }

        @Override
        public ResolvedArtifactSet getArtifactsWithId(int id) {
            return ResolvedArtifactSet.EMPTY;
        }
    }

    @VisibleForTesting
    public static class EmptyLenientConfiguration
    implements LenientConfigurationInternal {
        @Override
        public ArtifactSelectionSpec getImplicitSelectionSpec() {
            return new ArtifactSelectionSpec(ImmutableAttributes.EMPTY, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, ResolutionStrategy.SortOrder.DEFAULT);
        }

        @Override
        public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec) {
            return EmptyResults.INSTANCE;
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            return Collections.emptySet();
        }

        @Deprecated
        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFirstLevelModuleDependencies(Spec)").withAdvice("Use getFirstLevelModuleDependencies() instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
            return Collections.emptySet();
        }

        public Set<ResolvedDependency> getAllModuleDependencies() {
            return Collections.emptySet();
        }

        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            return Collections.emptySet();
        }

        @Deprecated
        public Set<File> getFiles() {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFiles()").withAdvice("Use a lenient ArtifactView instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_legacy_configuration_get_files")).nagUser();
            return Collections.emptySet();
        }

        @Deprecated
        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFiles(Spec)").withAdvice("Use a lenient ArtifactView with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
            return Collections.emptySet();
        }

        public Set<ResolvedArtifact> getArtifacts() {
            return Collections.emptySet();
        }

        @Deprecated
        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getArtifacts(Spec)").withAdvice("Use a lenient ArtifactView with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
            return Collections.emptySet();
        }
    }
}

