/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class SupplierUtils {
    private SupplierUtils() {
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, Function<T, R> resultHandler) {
        return () -> resultHandler.apply(supplier.get());
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, BiFunction<T, Throwable, R> handler) {
        return () -> {
            try {
                Object result = supplier.get();
                return handler.apply(result, null);
            }
            catch (Exception exception) {
                return handler.apply(null, exception);
            }
        };
    }

    public static <T> Supplier<T> recover(Supplier<T> supplier, Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
        return () -> {
            Object result = supplier.get();
            if (resultPredicate.test(result)) {
                return resultHandler.apply(result);
            }
            return result;
        };
    }

    public static <T> Supplier<T> recover(Supplier<T> supplier, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }

    public static <T> Supplier<T> recover(Supplier<T> supplier, List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                if (exceptionTypes.stream().anyMatch(exceptionType -> exceptionType.isAssignableFrom(exception.getClass()))) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }

    public static <X extends Throwable, T> Supplier<T> recover(Supplier<T> supplier, Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (RuntimeException exception) {
                if (exceptionType.isAssignableFrom(exception.getClass())) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, Function<T, R> resultHandler, Function<Throwable, R> exceptionHandler) {
        return () -> {
            try {
                Object result = supplier.get();
                return resultHandler.apply(result);
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }
}

