/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.common.collect.Lists;
import com.google.jstestdriver.coverage.CoverageAccumulator;
import com.google.jstestdriver.coverage.CoveredLine;
import com.google.jstestdriver.coverage.FileCoverage;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentedCode {
    private final List<Integer> executableLines;
    private final String instrumentedCode;
    private final String path;
    private final Integer fileId;

    public InstrumentedCode(Integer fileId, String path, List<Integer> executableLines, String instrumentedCode) {
        this.fileId = fileId;
        this.path = path;
        this.executableLines = executableLines;
        this.instrumentedCode = instrumentedCode;
    }

    public String getInstrumentedCode() {
        return this.instrumentedCode;
    }

    public String getPath() {
        return this.path;
    }

    public void writeInitialLines(CoverageAccumulator accumulator) {
        LinkedList initialLines = Lists.newLinkedList();
        for (Integer lineNumber : this.executableLines) {
            initialLines.add(new CoveredLine(lineNumber, 0));
        }
        accumulator.add("<initial lines>", Lists.newArrayList((Object[])new FileCoverage[]{new FileCoverage(this.fileId, initialLines)}));
    }
}

