/* splignAlign.h was originally generated by the autoSql program, which also 
 * generated splignAlign.c and splignAlign.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SPLIGNALIGN_H
#define SPLIGNALIGN_H

#define SPLIGNALIGN_NUM_COLS 10

struct splignAlign
/* NCBI tab-seperated alignment file */
    {
    struct splignAlign *next;  /* Next in singly linked list. */
    char *query;	/* query name */
    char *target;	/* target name */
    float perId;	/* percent identity */
    int match;	/* number of match bases */
    int qStart;	/* query start */
    int qEnd;	/* query end */
    int tStart;	/* target Start */
    int tEnd;	/* target End */
    char *type;	/* type of blocks */
    char *anotation;	/* anotation of misMatch, indel */
    };

void splignAlignStaticLoad(char **row, struct splignAlign *ret);
/* Load a row from splignAlign table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct splignAlign *splignAlignLoad(char **row);
/* Load a splignAlign from row fetched with select * from splignAlign
 * from database.  Dispose of this with splignAlignFree(). */

struct splignAlign *splignAlignLoadAll(char *fileName);
/* Load all splignAlign from whitespace-separated file.
 * Dispose of this with splignAlignFreeList(). */

struct splignAlign *splignAlignLoadAllByChar(char *fileName, char chopper);
/* Load all splignAlign from chopper separated file.
 * Dispose of this with splignAlignFreeList(). */

#define splignAlignLoadAllByTab(a) splignAlignLoadAllByChar(a, '\t');
/* Load all splignAlign from tab separated file.
 * Dispose of this with splignAlignFreeList(). */

struct splignAlign *splignAlignCommaIn(char **pS, struct splignAlign *ret);
/* Create a splignAlign out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new splignAlign */

void splignAlignFree(struct splignAlign **pEl);
/* Free a single dynamically allocated splignAlign such as created
 * with splignAlignLoad(). */

void splignAlignFreeList(struct splignAlign **pList);
/* Free a list of dynamically allocated splignAlign's */

void splignAlignOutput(struct splignAlign *el, FILE *f, char sep, char lastSep);
/* Print out splignAlign.  Separate fields with sep. Follow last field with lastSep. */

#define splignAlignTabOut(el,f) splignAlignOutput(el,f,'\t','\n');
/* Print out splignAlign as a line in a tab-separated file. */

#define splignAlignCommaOut(el,f) splignAlignOutput(el,f,',',',');
/* Print out splignAlign as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SPLIGNALIGN_H */

