# hapmapPhaseIIISummary.sql was originally generated by the autoSql program, which also 
# generated hapmapPhaseIIISummary.c and hapmapPhaseIIISummary.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#HapMap Phase III allele summaries for filtering (BED 5+)
CREATE TABLE hapmapPhaseIIISummary (
    bin smallint not null,      # Bin number for browser speedup
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chrom (0 based)
    chromEnd int unsigned not null,	# End position in chrom (1 based)
    name varchar(255) not null,	# Reference SNP identifier from dbSnp
    score int unsigned not null,	# Average of population heterozygosities in parts per thousand (0-500)
    observed varchar(255) not null,	# Observed string from genotype file
    overallMajorAllele char(1) not null,	# This allele has been observed in at least half of the populations that have data for this SNP
    overallMinorAllele char(1) not null,	# This allele may not have been observed in any HapMap sample
    popCount tinyint unsigned not null,	# How many Phase III populations have data (1-11)
    phaseIIPopCount tinyint unsigned not null,	# How many Phase II populations have data (0-4)
    isMixed tinyint unsigned not null,	# 0 if all populations have the same major allele, 1 otherwise.
    foundInPop longblob not null,	# Got data for each of the 11 Phase III populations?
    monomorphicInPop longblob not null,	# Monomorphic in each of the 11 Phase III populations?
    minFreq float not null,	# Minimum minor allele frequency across all populations
    maxFreq float not null,	# Maximum minor allele frequency across all populations
    orthoCount int unsigned not null,	# Species for which orthologous alleles have been determined
    orthoAlleles longblob not null,	# Orthologous allele for each species (or N if not found)
    orthoQuals longblob not null,	# Base quality score (0-100) for each species
              #Indices
    INDEX(chrom(8),bin),
    INDEX(name(12))
);
