/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConnectorConfigurator;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.CrossTenancyRequestClientFilter;
import com.oracle.bmc.util.internal.Validate;
import java.util.Arrays;

public class CrossTenancyRequestConfigurator
implements ClientConfigurator {
    private final ClientConfigurator baseConfigurator;
    private final String[] authorizedTenancyIds;

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds) {
        this(authorizedTenancyIds, new DefaultConnectorConfigurator());
    }

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds, ClientConfigurator baseConfigurator) {
        this.baseConfigurator = Validate.notNull(baseConfigurator, "baseConfigurator may not be null", new Object[0]);
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIds = Arrays.copyOf(authorizedTenancyIds, authorizedTenancyIds.length);
    }

    @Override
    public void customizeClient(HttpClientBuilder builder) {
        this.baseConfigurator.customizeClient(builder);
        builder.registerRequestInterceptor(999, (RequestInterceptor)new CrossTenancyRequestClientFilter(this.authorizedTenancyIds));
    }
}

