#ifndef __OSDM_DMW96_COMMON
#define __OSDM_DMW96_COMMON

#include <linux/fb.h>
#include "dwfb_utils_common.h"

/**************************************************************************
	Attention!
	When setting PLANAR / SEMI PLANAR image in the usespase application,
	each color complement should be set in word (32bit) aligned memory. 

		(Aligned to 32b)	(Aligned to 32b)	(Aligned to 32b)
		|					|					|
	Y	***********		U	***********		V 	***********

		(Aligned to 32b)	(Aligned to 32b)
		|					|			
	Y	***********		UV	***********	

***************************************************************************/


#define NUM_OF_IN_PLANES 5
#define NUM_OF_PLANES 6

#define OSDM_PALETTE_ARRAY_SIZE 256


#ifndef __KERNEL__
struct fb_info {
        struct fb_var_screeninfo var;	/* Current var */
		struct fb_fix_screeninfo fix;	/* Current fix */
        struct fb_cmap cmap;		/* Current cmap */
};

#endif

enum plane_type
{
	PLANE_TYPE_NOT_INIT = -1,
	MAIN_VIDEO_PLANE,
	SUB_VIDEO_PLANE,
	MAIN_OSD_PLANE,
	SUB_OSD_PLANE_1,
	SUB_OSD_PLANE_2,
	DISPLAY_PLANE
};


struct osdm_position {

 unsigned int xpos;
 unsigned int ypos;

};


struct osdm_mask
{	
	unsigned short left;
	unsigned short right;
	unsigned short  top;
	unsigned short  bottom;
};

struct osdm_video_color_control
{
	unsigned char brightness; //Brightness value(2's complement)
	unsigned char contrast;
	unsigned char saturation;
	unsigned char hue;

};


struct osdm_video_limits
{
	unsigned char luma_min;
	unsigned char luma_max;
	unsigned char chroma_min;
	unsigned char chroma_max;

};

struct regs_prop {
	unsigned int offset;
	unsigned int val;
};

struct osdm_regs
{
	unsigned int len;
	struct regs_prop reg[250];

};

/* Video OSD Define code 
(type) <-> (0) <-> (0) <-> (0) <-> (pkmode) <-> (plorg) <-> (fmt) <-> (0) 

(type)
1- OSD only
2- Video only
3- Both OSD and Video
4- Display only
	
(pkmode)
Depend on the format (fmt) and (plorg) look at the SPEC

(plorg)
0- Semi planar
1- Planar
2- Packed

(fmt)

Case of video:
0- YUV420_MPEG2
1- YUV420_JPEG
2- YUV422
3- YUV444
4- RGB565
5- RGBA16
6- RGBA32

Case of OSD:
0- 1 bit per pixel, palette
1- 2 bits per pixel, palette
2- 4 bits per pixel, palette
3- 8 bits per pixel, palette
4- 16b per pixel RGB (565)
5- 16 bits per pixel RGBA (4444)
6- 32b per pixel RGBA (8888)

*/

/*Applicable to OSD only*/
#define	OSDM_1_BPP_PALETTE		0x10000200
#define	OSDM_2_BPP_PALETTE		0x10000210 
#define	OSDM_4_BPP_PALETTE		0x10000220 
#define	OSDM_8_BPP_PALETTE		0x10000230

/*Applicable to video only*/
#define	OSDM_YUV420_MPEG2_PLANAR								0x20000100
#define	OSDM_YUV420_MPEG2_SEMI_PLANAR_V1_U1_V0_U0				0x20000000
#define	OSDM_YUV420_MPEG2_SEMI_PLANAR_U1_V1_U0_V0				0x20001000
#define	OSDM_YUV420_MPEG1_JPEG_PLANAR							0x20000110
#define	OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_V1_U1_V0_U0			0x20000010
#define	OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_U1_V1_U0_V0			0x20001010
#define	OSDM_YUV422_PLANAR										0x20000120
#define	OSDM_YUV422_SEMI_PLANAR_V1_U1_V0_U0						0x20000020
#define	OSDM_YUV422_SEMI_PLANAR_U1_V1_U0_V0						0x20001020
#define	OSDM_YUV422_Y1_V_Y0_U									0x20000220
#define	OSDM_YUV422_Y1_U_Y0_V									0x20001220
#define	OSDM_YUV422_V_Y1_U_Y0									0x20002220
#define	OSDM_YUV422_U_Y1_V_Y0									0x20003220
#define	OSDM_YUV422_Y1_Y0_V_U									0x20004220
#define	OSDM_YUV422_Y1_Y0_U_V									0x20005220
#define	OSDM_YUV422_V_U_Y1_Y0									0x20006220
#define	OSDM_YUV422_U_V_Y1_Y0									0x20007220
#define	OSDM_YUV444_PLANAR										0x20000130
#define	OSDM_YUV444_SEMI_PLANAR_V1_U1_V0_U0						0x20000030
#define	OSDM_YUV444_SEMI_PLANAR_U1_V1_U0_V0						0x20001030

/*Applicable to both OSD and video*/
#define	OSDM_RGB32_8888_ARGB	0x30000260
#define	OSDM_RGB32_8888_ARBG	0x30001260
#define	OSDM_RGB32_8888_AGRB	0x30002260
#define	OSDM_RGB32_8888_AGBR	0x30003260
#define	OSDM_RGB32_8888_ABRG	0x30004260
#define	OSDM_RGB32_8888_ABGR	0x30005260
#define	OSDM_RGB32_8888_RGBA	0x30008260
#define	OSDM_RGB32_8888_RBGA	0x30009260
#define	OSDM_RGB32_8888_GRBA	0x3000a260
#define	OSDM_RGB32_8888_GBRA	0x3000b260
#define	OSDM_RGB32_8888_BRGA	0x3000c260
#define	OSDM_RGB32_8888_BGRA	0x3000d260

#define	OSDM_RGB16_4444_ARGB	0x30000250
#define	OSDM_RGB16_4444_ARBG	0x30001250
#define	OSDM_RGB16_4444_AGRB	0x30002250
#define	OSDM_RGB16_4444_AGBR	0x30003250
#define	OSDM_RGB16_4444_ABRG	0x30004250
#define	OSDM_RGB16_4444_ABGR	0x30005250
#define	OSDM_RGB16_4444_RGBA	0x30008250
#define	OSDM_RGB16_4444_RBGA	0x30009250
#define	OSDM_RGB16_4444_GRBA	0x3000a250
#define	OSDM_RGB16_4444_GBRA	0x3000b250
#define	OSDM_RGB16_4444_BRGA	0x3000c250
#define	OSDM_RGB16_4444_BGRA	0x3000d250

#define	OSDM_RGB16_565_RGB		0x30000240
#define	OSDM_RGB16_565_BGR		0x30001240

/*Applicable to display only*/
#define OSDM_DISPLAY_RGB24_888_RGB    0x40000000
#define OSDM_DISPLAY_RGB24_888_RBG    0x40001000
#define OSDM_DISPLAY_RGB24_888_GRB    0x40002000
#define OSDM_DISPLAY_RGB24_888_GBR    0x40003000
#define OSDM_DISPLAY_RGB24_888_BRG    0x40004000
#define OSDM_DISPLAY_RGB24_888_BGR    0x40005000

#define	OSDM_DISPLAY_RGB16_565_RGB    0x40000010
#define	OSDM_DISPLAY_RGB16_565_BGR    0x40001010

#define	OSDM_DISPLAY_YUV422_Y1_V_Y0_U			0x40000030
#define	OSDM_DISPLAY_YUV422_Y1_U_Y0_V			0x40001030
#define	OSDM_DISPLAY_YUV422_V_Y1_U_Y0			0x40002030
#define	OSDM_DISPLAY_YUV422_U_Y1_V_Y0			0x40003030
#define	OSDM_DISPLAY_YUV422_Y1_Y0_V_U			0x40004030
#define	OSDM_DISPLAY_YUV422_Y1_Y0_U_V			0x40005030
#define	OSDM_DISPLAY_YUV422_V_U_Y1_Y0			0x40006030
#define	OSDM_DISPLAY_YUV422_U_V_Y1_Y0			0x40007030

enum byte_order_t {BYTE_ORDER_ABCD, BYTE_ORDER_ABDC, BYTE_ORDER_BACD, BYTE_ORDER_BADC, BYTE_ORDER_CDAB, BYTE_ORDER_CDBA, BYTE_ORDER_DCAB, BYTE_ORDER_DCBA}; 

#ifndef __KERNEL__
	//_IOW(type,nr,size)
	#ifndef _IOW
		#define _IOW(type,nr,size)	((unsigned int)(nr))
	#endif
	#ifndef _IOR
		#define _IOR(type,nr,size)	((unsigned int)(nr))
	#endif
#endif

/* DEBUG IOCTLs */
#define FBIOSET_OSDM_SET_REGS						_IOW('W',22, struct osdm_regs)
#define FBIOSET_OSDM_GET_REGS						_IOW('R',23, struct osdm_regs)

/* Display IOCTLs */
#define FBIOSET_OSDM_DISPLAY_PAUSE						_IOW('W',25, unsigned int)
#define FBIOSET_OSDM_DISPLAY_LOOP						_IOW('W',26, unsigned int)
#define FBIOSET_OSDM_DISPLAY_CONFIG						_IOW('W',27, unsigned int)
#define FBIOSET_OSDM_DISPLAY_DITHERING					_IOW('W',29, unsigned int)
//#define FBIOSET_OSDM_DISPLAY_DIMENTIONS					_IOW('W',30, struct fb_info) 
#define FBIOSET_OSDM_DISPLAY_BACKGROUND	    			_IOW('W',31, osdm_rgb888)
#define FBIOGET_OSDM_DISPLAY_BACKGROUND					_IOR('R',32, osdm_rgb888)
#define FBIOSET_OSDM_DISPLAY_BACKGROUND_ENB	    		_IOW('W',33, unsigned int)

/* Video / OSD IOCTLs */
#define FBIOSET_OSDM_PLANE_ENB							_IOW('W',36, unsigned int)
#define FBIOSET_OSDM_CHROMA_KEY_ENB						_IOW('W',37, unsigned int)
#define FBIOSET_OSDM_PER_PIXEL_ALPHA_ENB				_IOW('W',38, unsigned int)
#define FBIOSET_OSDM_CONFIG								_IOW('W',39, unsigned int)
#define FBIOSET_OSDM_MASK								_IOW('W',40, struct osdm_mask)
#define FBIOSET_OSDM_POS								_IOW('W',41, struct osdm_position)
#define FBIOGET_OSDM_POS								_IOR('R',42, struct osdm_position)

#define FBIOSET_OSDM_TRANSPARENCY_DIM					_IOW('W',43, struct fb_var_screeninfo)
#define FBIOGET_OSDM_TRANSPARENCY_DIM					_IOR('R',44, struct fb_var_screeninfo)
#define FBIOSET_OSDM_TRANSPARENCY_POS					_IOW('W',45, struct osdm_position)
#define FBIOGET_OSDM_TRANSPARENCY_POS					_IOR('R',46, struct osdm_position)
#define FBIOSET_OSDM_TRANSPARENCY_PIXEL					_IOW('W',47, osdm_abgr8888)
#define FBIOGET_OSDM_TRANSPARENCY_PIXEL					_IOR('R',48, osdm_abgr8888)

#define FBIOSET_OSDM_PER_PLANE_ALPHA					_IOW('W',49, unsigned char)
#define FBIOGET_OSDM_PER_PLANE_ALPHA					_IOR('R',50, unsigned char)
#define FBIOSET_OSDM_CHROMA_KEY							_IOW('W',51, osdm_rgb888)
#define FBIOGET_OSDM_CHROMA_KEY							_IOR('R',52, osdm_rgb888)
#define FBIOSET_OSDM_BYTE_ORDER							_IOW('W',53, unsigned int)
#define FBIOGET_OSDM_BYTE_ORDER							_IOR('R',54, unsigned int)

/* Video plane IOCTL's*/
#define FBIOSET_OSDM_VIDEO_LIMIT						_IOW('W',55, struct osdm_video_limits)
#define FBIOGET_OSDM_VIDEO_LIMIT						_IOR('R',56, struct osdm_video_limits)
#define FBIOSET_OSDM_VIDEO_COLOR_CONTROL 				_IOW('W',57, struct osdm_video_color_control)
#define FBIOGET_OSDM_VIDEO_COLOR_CONTROL 				_IOR('R',58, struct osdm_video_color_control)

/* OSD plane IOCTL's*/
#define FBIOSET_OSDM_LUT_BASE							_IOW('W',59, unsigned int)
#define FBIOGET_OSDM_LUT_BASE							_IOR('R',60, unsigned int)

#define FBIOPUT_OSDM_VSCREENINFO					_IOW('W',61, struct fb_var_screeninfo)
#define FBIOGET_OSDM_VSCREENINFO					_IOR('R',62, struct fb_var_screeninfo)

/* This IOCTL perform setting to the HW, mix and pan operation
   Whenever the plane is disabled this IOCTL will not perfom mix the the plane
*/
#define FBIOPAN_OSDM_DISPLAY						_IOW('W',63, struct fb_var_screeninfo)
#define PAN_OSDM_ZERO_COPY_MAGIC					0x12345678

#define IS_VIDEO_420(x) (( (x) == (OSDM_YUV420_MPEG2_PLANAR) || (x) == (OSDM_YUV420_MPEG2_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV420_MPEG2_SEMI_PLANAR_U1_V1_U0_V0) || (x) == (OSDM_YUV420_MPEG1_JPEG_PLANAR) || (x) == (OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_U1_V1_U0_V0) ) ? 1 : 0)
#define IS_VIDEO_422(x) (( (x) == (OSDM_YUV422_PLANAR) || (x) == (OSDM_YUV422_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV422_SEMI_PLANAR_U1_V1_U0_V0) || (x) == (OSDM_YUV422_Y1_V_Y0_U) || (x) == (OSDM_YUV422_Y1_U_Y0_V) || (x) == (OSDM_YUV422_V_Y1_U_Y0) || (x) == (OSDM_YUV422_U_Y1_V_Y0) || (x) == (OSDM_YUV422_Y1_Y0_V_U) || (x) == (OSDM_YUV422_Y1_Y0_U_V) || (x) == (OSDM_YUV422_V_U_Y1_Y0) || (x) == (OSDM_YUV422_U_V_Y1_Y0) ) ? 1 : 0 )
#define IS_VIDEO_444(x) (( (x) == (OSDM_YUV444_PLANAR) || (x) == (OSDM_YUV444_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV444_SEMI_PLANAR_U1_V1_U0_V0) ) ? 1 : 0 )

#define IS_PLANAR(x)		( (x) == (OSDM_YUV420_MPEG2_PLANAR) || (x) == (OSDM_YUV420_MPEG1_JPEG_PLANAR) ||  (x) == (OSDM_YUV422_PLANAR) ||  (x) == (OSDM_YUV444_PLANAR) )
#define IS_SEMIPLANAR(x)	( (x) == (OSDM_YUV420_MPEG2_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV420_MPEG2_SEMI_PLANAR_U1_V1_U0_V0) || (x) == (OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_U1_V1_U0_V0) || (x) == (OSDM_YUV422_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV422_SEMI_PLANAR_U1_V1_U0_V0) || (x) == (OSDM_YUV444_SEMI_PLANAR_V1_U1_V0_U0) || (x) == (OSDM_YUV444_SEMI_PLANAR_U1_V1_U0_V0) )
#define IS_PACKED(x)		( !(IS_PLANAR(x)) && !(IS_SEMIPLANAR(x)) )

#define IS_RGB32(x)			( (x) == (OSDM_RGB32_8888_ARGB) || (x) == (OSDM_RGB32_8888_ARBG) || (x) == (OSDM_RGB32_8888_AGRB) || (x) == (OSDM_RGB32_8888_AGBR) || (x) == (OSDM_RGB32_8888_ABRG) || (x) == (OSDM_RGB32_8888_ABGR) || (x) == (OSDM_RGB32_8888_RGBA) || (x) == (OSDM_RGB32_8888_RBGA) || (x) == (OSDM_RGB32_8888_GRBA) || (x) == (OSDM_RGB32_8888_GBRA) || (x) == (OSDM_RGB32_8888_BRGA) || (x) == (OSDM_RGB32_8888_BGRA) )
#define IS_RGB16(x)			( (x) == (OSDM_RGB16_4444_ARGB) || (x) == (OSDM_RGB16_4444_ARBG) || (x) == (OSDM_RGB16_4444_AGRB) || (x) == (OSDM_RGB16_4444_AGBR) || (x) == (OSDM_RGB16_4444_ABRG) || (x) == (OSDM_RGB16_4444_ABGR) || (x) == (OSDM_RGB16_4444_RGBA) || (x) == (OSDM_RGB16_4444_RBGA) || (x) == (OSDM_RGB16_4444_GRBA) || (x) == (OSDM_RGB16_4444_GBRA) || (x) == (OSDM_RGB16_4444_BRGA) || (x) == (OSDM_RGB16_4444_BGRA) || (x) == (OSDM_RGB16_565_RGB) || (x) == (OSDM_RGB16_565_BGR) )
#define IS_8BPP(x)			( (x) == (OSDM_8_BPP_PALETTE) )


#define ALIGNED_TO_32(add) (((((unsigned int)(add)) + 3)/4)*4)

#define DMW96OSDM_GET_Y_RGB_ADDRESS(xres ,yres, config , addr) ((unsigned int)(addr))

#define DMW96OSDM_GET_U_UV_ADDRESS(xres ,yres, config , addr) ALIGNED_TO_32( (((unsigned int)(xres) * (unsigned int)(yres)) + (unsigned int)(addr)) )

#define DMW96OSDM_GET_V_ADDRESS(xres ,yres, config , addr) ALIGNED_TO_32( DMW96OSDM_GET_U_UV_ADDRESS(xres ,yres, config , addr) + ( ((unsigned int)(xres) * (unsigned int)(yres)) / ( IS_VIDEO_420(config) ? 4 : (IS_VIDEO_422(config) ? 2 : 1) )) );

#endif



