/* Copyright (c) 1995 by Internet Software Consortium
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* testfiles - a really slow version of "cat" that tests file I/O events
 * vix 13sep95 [initial]
 */

#if !defined(LINT) && !defined(CODECENTER)
static const char rcsid[] = "$Id: testfiles.c,v 1.2 1995/09/17 23:12:25 vixie Exp $";
#endif

#include <assert.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "eventlib.h"

#ifdef DEBUG
int evDebugLev = 10;
#endif

struct closure {
	int otherFD;
	evFileID id;
};

void
myCopyFunc(evContext ctx, void *uap, int fd, int eventmask) {
	struct closure *c = uap;
	char buf[BUFSIZ];
	int len;

	len = read(fd, buf, sizeof buf);
	if (len <= 0) {
		evDeselectFD(ctx, c->id);
		free(uap);
	} else
		write(c->otherFD, buf, len);
}

int
main(int argc, char *argv[]) {
	evContext ev;
	struct closure *c;

	puts("This is a really slow version of ``cat''.  Type something.");
	evOpen(&ev);
	if (!(c = malloc(sizeof *c))) {
		printf("out of memory?\n");
		exit(1);
	}
	c->otherFD = STDOUT_FILENO;
	if (evSelectFD(ev, STDIN_FILENO, EV_READ, myCopyFunc, c, &c->id) < 0) {
		perror("evSelectFD");
		exit(1);
	}

	assert(evMainLoop(ev) == -1);
	if (errno != ENOENT)
		perror("evMainLoop");
	evClose(ev);
	exit(0);
	/*NOTREACHED*/
}
